/**
 * 
 */
package gov.va.med.mhv.phr.util;

import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;

import gov.va.med.mhv.core.util.Precondition;

/**
 * @author Rob Proper
 *
 */
public class PHRMessages {
	
	public static final String PATIENT_NOT_IN_PERSON_AUTHENTICATED = 
		"phr.patient_not_ipaed";

    public static final String EXTRACT_UNAVAILABLE = 
        "phr.extract.unavailable";

    public static final String EXTRACT_UPDATES_UNAVAILABLE = 
        "phr.extract.updates.unavailable";
    
    public static final String EXTRACT_UPDATE_COMPLETE = 
        "phr.extract.update.complete";

    public static final String PATIENT_NOT_CORRELATED = 
    	"phr.extract.patient.not.correlated";
    
	/**
	 * 
	 */
	private  PHRMessages() {
	}

	public static final Message createPatientIsNotAuthenticatedInMessage() {
		final String[] properties = {};
		final Object[] inserts = {};
		return MessageUtils.createInformationalMessage(
            PATIENT_NOT_IN_PERSON_AUTHENTICATED, properties, inserts);
	}

    public static final Message createExtractUnavailableMessage(
        String extractName) 
    {
        Precondition.assertNotBlank("extractName", extractName);
        final String[] properties = {};
        final Object[] inserts = {
            extractName
        };
        return MessageUtils.createErrorMessage(EXTRACT_UNAVAILABLE, 
            properties, inserts);
    }

    public static final Message createExtractUpdatesUnavailableMessage(
        String extractName) 
    {
        Precondition.assertNotBlank("extractName", extractName);
        final String[] properties = {};
        final Object[] inserts = {
            extractName
        };
        return MessageUtils.createErrorMessage(
            EXTRACT_UPDATES_UNAVAILABLE, properties, inserts);
    }

    public static final Message createExtractUpdateCompleteMessage(
        String extractName) 
    {
        Precondition.assertNotBlank("extractName", extractName);
        final String[] properties = {};
        final Object[] inserts = {
            extractName
        };
        return MessageUtils.createInformationalMessage(EXTRACT_UPDATE_COMPLETE, 
            properties, inserts);
    }

    public static final Message createExtractPatientUnCorrelated(String extractName){
    	Precondition.assertNotNull("extractName", extractName);
    	final String[] properties = {};
        final Object[] inserts = {
            extractName
        };
        return MessageUtils.createInformationalMessage(PATIENT_NOT_CORRELATED, 
                properties, inserts);
    }
    
}
